using System;
using System.IO;
using System.Collections.Generic;
using System.Text;

namespace MemStream
{
   class Program
   {
      static void Main(string[] args)
      {
         string sourceString = "Ala miaa maego kota.";
         MemoryStream ms = new MemoryStream(100);

         // przeka jakie dane do strumienia
         ms.Write(Encoding.GetEncoding(1250).GetBytes(sourceString),
            0, sourceString.Length);

         Console.WriteLine("Po wstpnym zapisie:");
         Console.WriteLine(
            string.Format("Pojemno: {0}\nDugo: {1}\nPozycja: {2}",
            ms.Capacity, ms.Length, ms.Position));

         ms.Seek(0, SeekOrigin.Begin);
         // odczytaj pierwsze 3 bajty ze strumienia
         byte[] tempBytes = new byte[sourceString.Length];
         ms.Read(tempBytes, 0, 3);

         Console.WriteLine(Encoding.GetEncoding(1250).GetString(tempBytes));

         // pobierz wyraz "kota"
         ms.Seek(-5, SeekOrigin.End);
         ms.Read(tempBytes, 0, 4);
         Console.WriteLine(Encoding.GetEncoding(1250).GetString(tempBytes));

         // zapisz jakie dane
         ms.Seek(10, SeekOrigin.Begin);
         ms.Write(Encoding.GetEncoding(1250).GetBytes("bardzo"), 0, 6);

         // teraz odczytaj cay cig
         ms.Seek(0, SeekOrigin.Begin);
         ms.Read(tempBytes, 0, (int)ms.Length);
         Console.WriteLine(Encoding.GetEncoding(1250).GetString(tempBytes));

         ms.Close();

         Console.ReadLine();
      }
   }
}
